library ieee;
use ieee.std_logic_1164.all;

package alt_syn_decl_pack is
component a_add8
    port (
        cout : OUT STD_LOGIC := 'Z';
        s : OUT STD_LOGIC_VECTOR(7 downto 0) := (others => 'Z');
        a : IN STD_LOGIC_VECTOR(7 downto 0) := (others => 'Z');
        b : IN STD_LOGIC_VECTOR(7 downto 0) := (others => 'Z');
        cin : IN STD_LOGIC := 'Z'
    );
end component;

component a_barrel8l_ldst
    port (
        q : OUT STD_LOGIC_VECTOR(7 downto 0) := (others => 'Z');
        clk : IN STD_LOGIC := 'Z';
        d : IN STD_LOGIC_VECTOR(7 downto 0) := (others => 'Z');
        ldst : IN STD_LOGIC := 'Z';
        shift : IN STD_LOGIC := 'Z'
    );
end component;

component a_barrel8r_ldst
    port (
        q : OUT STD_LOGIC_VECTOR(7 downto 0) := (others => 'Z');
        clk : IN STD_LOGIC := 'Z';
        d : IN STD_LOGIC_VECTOR(7 downto 0) := (others => 'Z');
        ldst : IN STD_LOGIC := 'Z';
        shift : IN STD_LOGIC := 'Z'
    );
end component;

component a_count4_dnup_clrn
    port (
        cout : OUT STD_LOGIC := 'Z';
        q : OUT STD_LOGIC_VECTOR(3 downto 0) := (others => 'Z');
        cin : IN STD_LOGIC := 'Z';
        clk : IN STD_LOGIC := 'Z';
        clrn : IN STD_LOGIC := 'Z';
        dnup : IN STD_LOGIC := 'Z'
    );
end component;

component a_count4_dnup_ldn_clrn
    port (
        cout : OUT STD_LOGIC := 'Z';
        q : OUT STD_LOGIC_VECTOR(3 downto 0) := (others => 'Z');
        cin : IN STD_LOGIC := 'Z';
        clk : IN STD_LOGIC := 'Z';
        clrn : IN STD_LOGIC := 'Z';
        d : IN STD_LOGIC_VECTOR(3 downto 0) := (others => 'Z');
        dnup : IN STD_LOGIC := 'Z';
        ldn : IN STD_LOGIC := 'Z'
    );
end component;

component a_count4_dnup_setn
    port (
        cout : OUT STD_LOGIC := 'Z';
        q : OUT STD_LOGIC_VECTOR(3 downto 0) := (others => 'Z');
        cin : IN STD_LOGIC := 'Z';
        clk : IN STD_LOGIC := 'Z';
        d : IN STD_LOGIC_VECTOR(3 downto 0) := (others => 'Z');
        dnup : IN STD_LOGIC := 'Z';
        setn : IN STD_LOGIC := 'Z'
    );
end component;

component a_count8_dnup_clrn
    port (
        cout : OUT STD_LOGIC := 'Z';
        q : OUT STD_LOGIC_VECTOR(7 downto 0) := (others => 'Z');
        clk : IN STD_LOGIC := 'Z';
        clrn : IN STD_LOGIC := 'Z';
        dnup : IN STD_LOGIC := 'Z';
        gn : IN STD_LOGIC := 'Z'
    );
end component;

component a_count8_dnup_ldn_clrn
    port (
        cout : OUT STD_LOGIC := 'Z';
        q : OUT STD_LOGIC_VECTOR(7 downto 0) := (others => 'Z');
        clk : IN STD_LOGIC := 'Z';
        clrn : IN STD_LOGIC := 'Z';
        d : IN STD_LOGIC_VECTOR(7 downto 0) := (others => 'Z');
        dnup : IN STD_LOGIC := 'Z';
        gn : IN STD_LOGIC := 'Z';
        ldn : IN STD_LOGIC := 'Z'
    );
end component;

component a_count8_dnup_setn
    port (
        cout : OUT STD_LOGIC := 'Z';
        q : OUT STD_LOGIC_VECTOR(7 downto 0) := (others => 'Z');
        clk : IN STD_LOGIC := 'Z';
        d : IN STD_LOGIC_VECTOR(7 downto 0) := (others => 'Z');
        dnup : IN STD_LOGIC := 'Z';
        gn : IN STD_LOGIC := 'Z';
        setn : IN STD_LOGIC := 'Z'
    );
end component;

component a_gnd
    port (
        y : OUT STD_LOGIC := 'Z'
    );
end component;

component a_mux161
    port (
        y : OUT STD_LOGIC := 'Z';
        a : IN STD_LOGIC := 'Z';
        b : IN STD_LOGIC := 'Z';
        c : IN STD_LOGIC := 'Z';
        d : IN STD_LOGIC := 'Z';
        d0 : IN STD_LOGIC := 'Z';
        d1 : IN STD_LOGIC := 'Z';
        d2 : IN STD_LOGIC := 'Z';
        d3 : IN STD_LOGIC := 'Z';
        d4 : IN STD_LOGIC := 'Z';
        d5 : IN STD_LOGIC := 'Z';
        d6 : IN STD_LOGIC := 'Z';
        d7 : IN STD_LOGIC := 'Z';
        d8 : IN STD_LOGIC := 'Z';
        d9 : IN STD_LOGIC := 'Z';
        d10 : IN STD_LOGIC := 'Z';
        d11 : IN STD_LOGIC := 'Z';
        d12 : IN STD_LOGIC := 'Z';
        d13 : IN STD_LOGIC := 'Z';
        d14 : IN STD_LOGIC := 'Z';
        d15 : IN STD_LOGIC := 'Z'
    );
end component;

component a_mux21
    port (
        y : OUT STD_LOGIC := 'Z';
        a : IN STD_LOGIC := 'Z';
        b : IN STD_LOGIC := 'Z';
        s : IN STD_LOGIC := 'Z'
    );
end component;

component a_mux2x8
    port (
        y : OUT STD_LOGIC_VECTOR(7 downto 0) := (others => 'Z');
        a : IN STD_LOGIC_VECTOR(7 downto 0) := (others => 'Z');
        b : IN STD_LOGIC_VECTOR(7 downto 0) := (others => 'Z');
        s : IN STD_LOGIC := 'Z'
    );
end component;

component a_mux81
    port (
        wn : OUT STD_LOGIC := 'Z';
        y : OUT STD_LOGIC := 'Z';
        a : IN STD_LOGIC := 'Z';
        b : IN STD_LOGIC := 'Z';
        c : IN STD_LOGIC := 'Z';
        d0 : IN STD_LOGIC := 'Z';
        d1 : IN STD_LOGIC := 'Z';
        d2 : IN STD_LOGIC := 'Z';
        d3 : IN STD_LOGIC := 'Z';
        d4 : IN STD_LOGIC := 'Z';
        d5 : IN STD_LOGIC := 'Z';
        d6 : IN STD_LOGIC := 'Z';
        d7 : IN STD_LOGIC := 'Z'
    );
end component;

component a_shift8l_ldst
    port (
        q : OUT STD_LOGIC_VECTOR(7 downto 0) := (others => 'Z');
        clk : IN STD_LOGIC := 'Z';
        clrn : IN STD_LOGIC := 'Z';
        d : IN STD_LOGIC_VECTOR(7 downto 0) := (others => 'Z');
        ldst : IN STD_LOGIC := 'Z';
        shift : IN STD_LOGIC := 'Z';
        sin : IN STD_LOGIC := 'Z'
    );
end component;

component a_shift8r_ldst
    port (
        q : OUT STD_LOGIC_VECTOR(7 downto 0) := (others => 'Z');
        clk : IN STD_LOGIC := 'Z';
        clrn : IN STD_LOGIC := 'Z';
        d : IN STD_LOGIC_VECTOR(7 downto 0) := (others => 'Z');
        ldst : IN STD_LOGIC := 'Z';
        shift : IN STD_LOGIC := 'Z';
        sin : IN STD_LOGIC := 'Z'
    );
end component;

component a_tri
    port (
        y : OUT STD_LOGIC := 'Z';
        oe : IN STD_LOGIC := 'Z';
        a : IN STD_LOGIC := 'Z'
    );
end component;

component a_vcc
    port (
        y : OUT STD_LOGIC := 'Z'
    );
end component;

component alt_syn_env
end component;

component and12
    port (
        y : OUT STD_LOGIC := 'Z';
        a : IN STD_LOGIC := 'Z';
        b : IN STD_LOGIC := 'Z';
        c : IN STD_LOGIC := 'Z';
        d : IN STD_LOGIC := 'Z';
        e : IN STD_LOGIC := 'Z';
        f : IN STD_LOGIC := 'Z';
        g : IN STD_LOGIC := 'Z';
        h : IN STD_LOGIC := 'Z';
        i : IN STD_LOGIC := 'Z';
        j : IN STD_LOGIC := 'Z';
        k : IN STD_LOGIC := 'Z';
        l : IN STD_LOGIC := 'Z'
    );
end component;

component and2
    port (
        y : OUT STD_LOGIC := 'Z';
        a : IN STD_LOGIC := 'Z';
        b : IN STD_LOGIC := 'Z'
    );
end component;

component and3
    port (
        y : OUT STD_LOGIC := 'Z';
        a : IN STD_LOGIC := 'Z';
        b : IN STD_LOGIC := 'Z';
        c : IN STD_LOGIC := 'Z'
    );
end component;

component and4
    port (
        y : OUT STD_LOGIC := 'Z';
        a : IN STD_LOGIC := 'Z';
        b : IN STD_LOGIC := 'Z';
        c : IN STD_LOGIC := 'Z';
        d : IN STD_LOGIC := 'Z'
    );
end component;

component and6
    port (
        y : OUT STD_LOGIC := 'Z';
        a : IN STD_LOGIC := 'Z';
        b : IN STD_LOGIC := 'Z';
        c : IN STD_LOGIC := 'Z';
        d : IN STD_LOGIC := 'Z';
        e : IN STD_LOGIC := 'Z';
        f : IN STD_LOGIC := 'Z'
    );
end component;

component and8
    port (
        y : OUT STD_LOGIC := 'Z';
        a : IN STD_LOGIC := 'Z';
        b : IN STD_LOGIC := 'Z';
        c : IN STD_LOGIC := 'Z';
        d : IN STD_LOGIC := 'Z';
        e : IN STD_LOGIC := 'Z';
        f : IN STD_LOGIC := 'Z';
        g : IN STD_LOGIC := 'Z';
        h : IN STD_LOGIC := 'Z'
    );
end component;

component carry
    port (
        y : OUT STD_LOGIC := 'Z';
        a : IN STD_LOGIC := 'Z'
    );
end component;

component cascade
    port (
        y : OUT STD_LOGIC := 'Z';
        a : IN STD_LOGIC := 'Z'
    );
end component;

component dff
    port (
        q : OUT STD_LOGIC := 'Z';
        d : IN STD_LOGIC := 'Z';
        clk : IN STD_LOGIC := 'Z';
        clrn : IN STD_LOGIC := 'Z';
        prn : IN STD_LOGIC := 'Z'
    );
end component;

component dffe
    port (
        q : OUT STD_LOGIC := 'Z';
        d : IN STD_LOGIC := 'Z';
        clk : IN STD_LOGIC := 'Z';
        clrn : IN STD_LOGIC := 'Z';
        ena : IN STD_LOGIC := 'Z';
        prn : IN STD_LOGIC := 'Z'
    );
end component;

component exp
    port (
        y : OUT STD_LOGIC := 'Z';
        a : IN STD_LOGIC := 'Z'
    );
end component;

component global
    port (
        y : OUT STD_LOGIC := 'Z';
        a : IN STD_LOGIC := 'Z'
    );
end component;

component inv
    port (
        y : OUT STD_LOGIC := 'Z';
        a : IN STD_LOGIC := 'Z'
    );
end component;

component latch
    port (
        q : OUT STD_LOGIC := 'Z';
        ena : IN STD_LOGIC := 'Z';
        d : IN STD_LOGIC := 'Z'
    );
end component;

component latch_clrn
    port (
        q : OUT STD_LOGIC := 'Z';
        clrn : IN STD_LOGIC := 'Z';
        d : IN STD_LOGIC := 'Z';
        ena : IN STD_LOGIC := 'Z'
    );
end component;

component latch_setn
    port (
        q : OUT STD_LOGIC := 'Z';
        d : IN STD_LOGIC := 'Z';
        ena : IN STD_LOGIC := 'Z';
        setn : IN STD_LOGIC := 'Z'
    );
end component;

component lcell
    port (
        y : OUT STD_LOGIC := 'Z';
        a : IN STD_LOGIC := 'Z'
    );
end component;

component nand12
    port (
        y : OUT STD_LOGIC := 'Z';
        a : IN STD_LOGIC := 'Z';
        b : IN STD_LOGIC := 'Z';
        c : IN STD_LOGIC := 'Z';
        d : IN STD_LOGIC := 'Z';
        e : IN STD_LOGIC := 'Z';
        f : IN STD_LOGIC := 'Z';
        g : IN STD_LOGIC := 'Z';
        h : IN STD_LOGIC := 'Z';
        i : IN STD_LOGIC := 'Z';
        j : IN STD_LOGIC := 'Z';
        k : IN STD_LOGIC := 'Z';
        l : IN STD_LOGIC := 'Z'
    );
end component;

component nand2
    port (
        y : OUT STD_LOGIC := 'Z';
        a : IN STD_LOGIC := 'Z';
        b : IN STD_LOGIC := 'Z'
    );
end component;

component nand3
    port (
        y : OUT STD_LOGIC := 'Z';
        a : IN STD_LOGIC := 'Z';
        b : IN STD_LOGIC := 'Z';
        c : IN STD_LOGIC := 'Z'
    );
end component;

component nand4
    port (
        y : OUT STD_LOGIC := 'Z';
        a : IN STD_LOGIC := 'Z';
        b : IN STD_LOGIC := 'Z';
        c : IN STD_LOGIC := 'Z';
        d : IN STD_LOGIC := 'Z'
    );
end component;

component nand6
    port (
        y : OUT STD_LOGIC := 'Z';
        a : IN STD_LOGIC := 'Z';
        b : IN STD_LOGIC := 'Z';
        c : IN STD_LOGIC := 'Z';
        d : IN STD_LOGIC := 'Z';
        e : IN STD_LOGIC := 'Z';
        f : IN STD_LOGIC := 'Z'
    );
end component;

component nand8
    port (
        y : OUT STD_LOGIC := 'Z';
        a : IN STD_LOGIC := 'Z';
        b : IN STD_LOGIC := 'Z';
        c : IN STD_LOGIC := 'Z';
        d : IN STD_LOGIC := 'Z';
        e : IN STD_LOGIC := 'Z';
        f : IN STD_LOGIC := 'Z';
        g : IN STD_LOGIC := 'Z';
        h : IN STD_LOGIC := 'Z'
    );
end component;

component nor12
    port (
        y : OUT STD_LOGIC := 'Z';
        a : IN STD_LOGIC := 'Z';
        b : IN STD_LOGIC := 'Z';
        c : IN STD_LOGIC := 'Z';
        d : IN STD_LOGIC := 'Z';
        e : IN STD_LOGIC := 'Z';
        f : IN STD_LOGIC := 'Z';
        g : IN STD_LOGIC := 'Z';
        h : IN STD_LOGIC := 'Z';
        i : IN STD_LOGIC := 'Z';
        j : IN STD_LOGIC := 'Z';
        k : IN STD_LOGIC := 'Z';
        l : IN STD_LOGIC := 'Z'
    );
end component;

component nor2
    port (
        y : OUT STD_LOGIC := 'Z';
        a : IN STD_LOGIC := 'Z';
        b : IN STD_LOGIC := 'Z'
    );
end component;

component nor3
    port (
        y : OUT STD_LOGIC := 'Z';
        a : IN STD_LOGIC := 'Z';
        b : IN STD_LOGIC := 'Z';
        c : IN STD_LOGIC := 'Z'
    );
end component;

component nor4
    port (
        y : OUT STD_LOGIC := 'Z';
        a : IN STD_LOGIC := 'Z';
        b : IN STD_LOGIC := 'Z';
        c : IN STD_LOGIC := 'Z';
        d : IN STD_LOGIC := 'Z'
    );
end component;

component nor6
    port (
        y : OUT STD_LOGIC := 'Z';
        a : IN STD_LOGIC := 'Z';
        b : IN STD_LOGIC := 'Z';
        c : IN STD_LOGIC := 'Z';
        d : IN STD_LOGIC := 'Z';
        e : IN STD_LOGIC := 'Z';
        f : IN STD_LOGIC := 'Z'
    );
end component;

component nor8
    port (
        y : OUT STD_LOGIC := 'Z';
        a : IN STD_LOGIC := 'Z';
        b : IN STD_LOGIC := 'Z';
        c : IN STD_LOGIC := 'Z';
        d : IN STD_LOGIC := 'Z';
        e : IN STD_LOGIC := 'Z';
        f : IN STD_LOGIC := 'Z';
        g : IN STD_LOGIC := 'Z';
        h : IN STD_LOGIC := 'Z'
    );
end component;

component or12
    port (
        y : OUT STD_LOGIC := 'Z';
        a : IN STD_LOGIC := 'Z';
        b : IN STD_LOGIC := 'Z';
        c : IN STD_LOGIC := 'Z';
        d : IN STD_LOGIC := 'Z';
        e : IN STD_LOGIC := 'Z';
        f : IN STD_LOGIC := 'Z';
        g : IN STD_LOGIC := 'Z';
        h : IN STD_LOGIC := 'Z';
        i : IN STD_LOGIC := 'Z';
        j : IN STD_LOGIC := 'Z';
        k : IN STD_LOGIC := 'Z';
        l : IN STD_LOGIC := 'Z'
    );
end component;

component or2
    port (
        y : OUT STD_LOGIC := 'Z';
        a : IN STD_LOGIC := 'Z';
        b : IN STD_LOGIC := 'Z'
    );
end component;

component or3
    port (
        y : OUT STD_LOGIC := 'Z';
        a : IN STD_LOGIC := 'Z';
        b : IN STD_LOGIC := 'Z';
        c : IN STD_LOGIC := 'Z'
    );
end component;

component or4
    port (
        y : OUT STD_LOGIC := 'Z';
        a : IN STD_LOGIC := 'Z';
        b : IN STD_LOGIC := 'Z';
        c : IN STD_LOGIC := 'Z';
        d : IN STD_LOGIC := 'Z'
    );
end component;

component or6
    port (
        y : OUT STD_LOGIC := 'Z';
        a : IN STD_LOGIC := 'Z';
        b : IN STD_LOGIC := 'Z';
        c : IN STD_LOGIC := 'Z';
        d : IN STD_LOGIC := 'Z';
        e : IN STD_LOGIC := 'Z';
        f : IN STD_LOGIC := 'Z'
    );
end component;

component or8
    port (
        y : OUT STD_LOGIC := 'Z';
        a : IN STD_LOGIC := 'Z';
        b : IN STD_LOGIC := 'Z';
        c : IN STD_LOGIC := 'Z';
        d : IN STD_LOGIC := 'Z';
        e : IN STD_LOGIC := 'Z';
        f : IN STD_LOGIC := 'Z';
        g : IN STD_LOGIC := 'Z';
        h : IN STD_LOGIC := 'Z'
    );
end component;

component soft
    port (
        y : OUT STD_LOGIC := 'Z';
        a : IN STD_LOGIC := 'Z'
    );
end component;

component tff
    port (
        clk : IN STD_LOGIC := 'Z';
        prn : IN STD_LOGIC := 'Z';
        clrn : IN STD_LOGIC := 'Z';
        t : IN STD_LOGIC := 'Z';
        q : OUT STD_LOGIC := 'Z'
    );
end component;

component xor2
    port (
        y : OUT STD_LOGIC := 'Z';
        a : IN STD_LOGIC := 'Z';
        b : IN STD_LOGIC := 'Z'
    );
end component;

end alt_syn_decl_pack;


